#	$NetBSD: dot.profile,v 1.1.2.1 2000/10/09 13:43:30 fvdl Exp $
# +HF
#
# Copyright (c) 1994 Christopher G. Demetriou
# Copyright (c) 1997 Perry E. Metzger
# Copyright (c) 2002-2004 Hubert Feyrer
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by Christopher G. Demetriou.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 

PATH=/sbin:/bin:/usr/bin:/usr/sbin:/
export PATH
TERM=pc3
export TERM
HOME=/
export HOME
BLOCKSIZE=1k
export BLOCKSIZE
EDITOR=ed
export EDITOR

umask 022

ROOTDEV=/dev/md0a

if [ "X${DONEPROFILE}" = "X" ]; then
	DONEPROFILE=YES
	export DONEPROFILE

	PS1='g4u> '

        # Create real /dev
        mount -t mfs -o-s12288 swap /dev 
        gzip -cd /MAKEDEV.gz > /dev/MAKEDEV 
        cd /dev
	echo -n Running MAKEDEV all ...
        sh MAKEDEV all 2>/dev/null >/dev/null
	echo done.
        cd ..

	# mount the ramdisk read write
	mount -u $ROOTDEV /
	mount -t kernfs foo /kern

	# functions that people will use from the shell prompt.
	dmesg() {
		( echo "dmesg: scroll down by pressing RETURN or SPACE!" ; 
		cat /kern/msgbuf ) | more
	}
	disks() {
		cat /kern/msgbuf | grep "^[swl]d[0-9]"
	}
	grep() sed -n "/$1/p"
	ls() echo *
	help() cat .usage

	dhclient
	echo -n Reading disklabels: 
	for disk in wd0 wd1 wd2 wd3 sd0 sd1 sd2 sd3
	do
		echo -n " $disk"
		mbrlabel -w ${disk} 2>/dev/null
	done
	echo .

	cat .usage
fi
